#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Abstract Liquid w_rotate_zoomMod01.fsh   by   timmaffett   
//https://www.shadertoy.com/view/Dtd3WH
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Fork of "Abstract Liquid" by SentientCymatic. https://shadertoy.com/view/ctd3z4
// 2023-04-24 18:02:54

vec2 hash2( float n ){return fract(sin(vec2(n,n+1.0))*vec2(432.14159,528.14159));}

const vec2 randConst = vec2(432., 528.);
const float randMultiplier = 3.14159;
float rand(const vec2 co) {
    return fract(sin(co.x * randConst.x + co.y * randConst.y) * randMultiplier);}

float custom_smoothstep(float edge0, float edge1, float x) {
    float t = clamp((x - edge0) / (edge1 - edge0), 0.1, 1.0);
    return t * t * (3.0 - 2.0 * t);}

float noise(in vec2 x){
    vec2 p = floor(x);
    vec2 f = fract(x);
    f = f * f * (3.0 - 2.0 * f);
    vec2 n = p + vec2(2.5, -2.5);
    float a = mix(rand(n), rand(n + vec2(1.0, 0.0)), f.x);
    float b = mix(rand(n + vec2(0.0, 1.0)), rand(n + vec2(1.0, 1.0)), f.x);
    return mix(a, b, f.y);}

vec2 turbulence(vec2 p, float t, float scale){
    float sum = 0.1;
    float freq = scale;
    float smoothness;
    vec2 noise_coord;
    for (int i = 0; i < 5; i++){
        smoothness = custom_smoothstep(0.0, 10.0, float(i));
        noise_coord = vec2(p + t * 0.25) + vec2(cos(float(i) * 0.6), sin(float(i) * 0.6)) * smoothness;
        sum += abs(noise(noise_coord)) / freq;
        freq *= 0.25;}
    return vec2(sum, sum) * 0.1;}

mat2 mtx = mat2( 0.87,  0.50, -0.50,  0.87 );

float fbm( vec2 p ){
    float f = 0.03;
    f += 0.980000*noise( p ); p = mtx*p*3.0;
    f += 0.210000*noise( p ); p = mtx*p*2.0;
    f += 0.070000*noise( p ); p = mtx*p*2.0;
    f += 0.060000*noise( p ); p = mtx*p*2.0;
    f += 0.030000*noise( p ); p = mtx*p*1.0;
    f += 0.010000*noise( p );
    p = mtx*p*2.0;
    f += 0.004000*noise( p );
    p = mtx*p*2.0;
    f += 0.002000*noise( p );
    return f/0.90000;}

float pattern(in vec2 p, in float t, in vec2 uv, out vec2 q, out vec2 r, out vec2 g) {
    float s = dot(uv + 0.5, uv + 0.5);
    float iMelty = 50.0, iFlowing = 10.0;
    float l = custom_smoothstep(0., iMelty, sin(t * iFlowing));
    q = mix(vec2(fbm(p + vec2(t * 1. + sin(t), t * 0.2 + cos(t))),
                 fbm(p + vec2(t * 0.5 + sin(t + 0.7), t * 0.3 + cos(t + 1.3)))),
            vec2(fbm(p), fbm(p + vec2(10.49, 1.37))),
            l);
    r = mix(vec2(fbm(p + 3.14159 * q + vec2(t * 0.2 + sin(t * 0.5), t * 0.2 + cos(t * 0.7)) + vec2(1.73, 9.6)),
                 fbm(p + 2. * q + vec2(t * 0.5 + sin(t * 0.3), t * 0.4 + cos(t * 0.9)) + vec2(8.5, 4.8))),
            vec2(fbm(p + 5. * q + vec2(t) + vec2(33.33, 66.66)), fbm(p + 4. * q + vec2(t) + vec2(8.3, 2.8))),
            l);
    g = mix(vec2(fbm(p + 2. * r + vec2(t * 0.5 + sin(t * 0.2), t * 0.3 + cos(t * 0.8)) + vec2(2, 6)),
                 fbm(p + 1.5 * r + vec2(t * 0.76 + sin(t * 0.4), t * 0.6 + cos(t * 0.6)) + vec2(5, 3))),
            vec2(fbm(p + 2.5 * r + vec2(t * 5.0) + vec2(2, 6)), fbm(p + 2. * r + vec2(t * 11.0) + vec2(5, 3))),
            l);
    vec2 v = turbulence(p * 0.1, t * 0.1, 20.);
    vec2 m = vec2(fbm(p * 0.5 + vec2(t * 0.9, t * 0.9) + v * 0.5),
                  fbm(p * 0.5 + vec2(t * 0.9, t * 0.9) + v * 0.5));
    return mix(fbm(p + 3. * g + vec2(-t * 0.7 + sin(t * 0.5), -t * 0.5 + cos(t * 0.3)) + v * 2. + m * 0.3),
               fbm(p + 5. * g + vec2(-t * 7.) + v * 3.),
               l);}


// simple mouse rotate and zoom for shader
#define pi 3.14159265359 

mat2 r2d(float a) {
    return mat2(cos(a),sin(a),-sin(a),cos(a));
}

vec2 mouseRotZoom(vec2 uv) {
    // allow mouse zoom and rotate    
    vec2 mouse = (iMouse.xy == vec2(0.)) ? vec2(1.0) : iMouse.xy/iResolution.xy;
    uv.xy *= r2d(-(mouse.x)*pi*2.);
    uv *= (1./(10.0*mouse.y));
    return uv;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    float iSmoke = 0.01;
    float iSpeed = 0.25;
    
    // center for rotate and zoom
    fragCoord -= iResolution.xy/2.0;
    fragCoord = mouseRotZoom(fragCoord);

    vec2 uv = fragCoord / iResolution.xy;
    
    
    vec2 q, r, g;
    float noise = pattern(fragCoord * vec2(iSmoke), iTime * iSpeed, uv, q, r, g);
    vec3 col = mix(vec3(0.2, 0.4, 0.2), vec3(0.0, 0.25, 0.5), custom_smoothstep(0.1, 1.0, noise));
    col = mix(col, vec3(0.4, 0.2, 0.2), dot(q, q) * 1.5);
    col = mix(col, vec3(0.2, 0.4, 0.0), 0.25 * g.y * g.y);
    col = mix(col, vec3(0.4, 0.2, 0.2), custom_smoothstep(0.2, 0.5, 1.0 * r.g * r.g));
    col = mix(col, vec3(0.2, 0.4, 0.6), 0.5 * g.x);
    float timeScale = .25;
    float xDrift = sin(uv.x * 3.14159 + iTime * timeScale);
    float yDrift = cos(uv.y * 3.14159 + iTime * timeScale);
    vec3 drift = vec3(xDrift, yDrift, -xDrift - yDrift) * .1;
    col += drift;
    col = mix(col, vec3(1), custom_smoothstep(0., 1000., noise) * custom_smoothstep(0., 1000., noise));
    col *= noise * 2.;
    fragColor = vec4(col, 1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

